import React, {Component} from 'react';
import PropTypes from 'prop-types';
import gql from 'graphql-tag';
import {graphql, compose} from "react-apollo";
import BlinkDot from "../Loading/BlinkDot";

class InterventoBreadcrumb extends Component {

    render() {
        const {data} = this.props;
        const {loading, intervento} = data;

        if(loading) {
            return (<span className="text-info" style={{fontWeight: "normal", fontSize: "1.3rem"}}>
                <BlinkDot/>
                <BlinkDot/>
                <BlinkDot/>
            </span>)
        }

        return (<span>
            {intervento.idScheda}
        </span>);
    }
}

export default compose(
    graphql(gql`
        query($id: Long) {
            intervento(id: $id) {
                id
                idScheda
            }
        }
    `, {
        options:({id}) => {return{variables: {id: id}}},
    }),
)(InterventoBreadcrumb);

InterventoBreadcrumb.defaultProps = {};

InterventoBreadcrumb.propTypes = {};